/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWIndexDefinition;
import filenet.vw.api.VWLogDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWStepProcessorInfoDefinition;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkBasketDefinition;
import filenet.vw.api.VWXMLConfiguration;
import filenet.vw.base.VWString;
import filenet.vw.server.IPECommands;
import filenet.vw.server.VWNoOnlineClassesException;
import filenet.vw.server.VWSystemConfigInfo;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.SAXParseException;

public final class VWSystemConfiguration
implements Serializable,
IVWtoXML {
    private static final long serialVersionUID = 7555L;
    public static final int LOG_NONE = 0;
    public static final int LOG_WOBJ_CREATION = 256;
    public static final int LOG_WOBJ_TERMINATION = 512;
    public static final int LOG_WOBJ_EXCEPTION = 1024;
    public static final int LOG_WOBJ_ADMINISTRATION = 4096;
    public static final int LOG_WOBJ_TRACE_INSTRUCTIONS = 128;
    public static final int LOG_WOBJ_EMPTY_STEP = 16;
    public static final int LOG_WOBJ_RULES = 32;
    public static final int LOG_BEGIN_SERVICE_OPERATION = 0x100000;
    public static final int LOG_END_SERVICE_OPERATION = 0x400000;
    public static final int LOG_USER_DEFINED_1 = 0x40000000;
    public static final int LOG_USER_DEFINED_2 = Integer.MIN_VALUE;
    public static final int LOG_SYSTEM_MESSAGES = 65536;
    public static final int LOG_MILESTONES = 64;
    public static final int LOG_ALL = -1068427280;
    private static final String ATTRINFO_CONFIG_OBJECT_STORE_ID = "F_ObjectStoreId";
    private static String[] LocalizedStrings = new String[]{new VWString("vw.api.VWSystemConfigurationLogNone", "Log None").toString(), new VWString("vw.api.VWSystemConfigurationLogAll", "Log All").toString(), new VWString("vw.api.VWSystemConfigurationLogWobjCreation", "Log Workobject Creation").toString(), new VWString("vw.api.VWSystemConfigurationLogWobjTermination", "Log Workobject Termination").toString(), new VWString("vw.api.VWSystemConfigurationLogWobjException", "Log Workobject Exception").toString(), new VWString("vw.api.VWSystemConfigurationLogWobjAdmin", "Log Workobject Administration").toString(), new VWString("vw.api.VWSystemConfigurationLogWobjTrace", "Log Workobject Trace Instructions").toString(), new VWString("vw.api.VWSystemConfigurationLogBeginService", "Log Begin Service Operation").toString(), new VWString("vw.api.VWSystemConfigurationLogEndService", "Log End Service Operation").toString(), new VWString("vw.api.VWSystemConfigurationLogUserDefined1", "Log User Defined 1").toString(), new VWString("vw.api.VWSystemConfigurationLogUserDefined2", "Log User Defined 2").toString(), new VWString("vw.api.VWSystemConfigurationLogSystemMessages", "Log System Messages").toString(), new VWString("vw.api.VWSystemConfigurationLogMilestones", "Log Milestones").toString(), new VWString("vw.api.VWSystemConfigurationLogEmptyStep", "Log Empty Step").toString(), new VWString("vw.api.VWSystemConfigurationLogRules", "Log Rules").toString()};
    private boolean bHasChanged = false;
    private VWSession serviceSession = null;
    private boolean m_bRetrievedFromServer = false;
    protected int maxDBOperations = 0;
    protected int maxInstructions = 0;
    protected boolean bStatisticsCollectionOn = false;
    protected boolean bTrackAttachmentReferences = false;
    protected int theLoggingOptions = 0;
    private VWArrayHandler QDefHandler = new VWArrayHandler();
    private VWQueueDefinition[] theQDefs = null;
    private VWExposedFieldDefinition[] mandatoryQExpFields = null;
    private VWIndexDefinition[] mandatoryQIndexes = null;
    private VWLogDefinition defaultLogDef = null;
    private VWArrayHandler LDefHandler = new VWArrayHandler();
    private VWLogDefinition[] theLDefs = null;
    private VWExposedFieldDefinition[] mandatoryLExpFields = null;
    private VWIndexDefinition[] mandatoryLIndexes = null;
    private VWArrayHandler RDefHandler = new VWArrayHandler();
    private VWRosterDefinition[] theRDefs = null;
    private VWExposedFieldDefinition[] mandatoryRExpFields = null;
    private VWIndexDefinition[] mandatoryRIndexes = null;
    private VWArrayHandler ApplicationSpaceDefHandler = new VWArrayHandler();
    private VWApplicationSpaceDefinition[] theApplicationSpaceDefs = null;
    private VWArrayHandler SPDefHandler = new VWArrayHandler();
    private VWStepProcessorInfoDefinition[] theSPDefs = null;
    private VWArrayHandler DeletedSPDefHandler = new VWArrayHandler();
    private VWStepProcessorInfoDefinition[] theDeletedSPDefs = null;
    protected Hashtable attributes = null;
    protected boolean isSelectedForExport = false;
    protected transient String objectStoreSymbolicName = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2011-01-19 23:56:34 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/PUI_460_FP01_Int/1 $";
    }

    public VWSystemConfiguration() {
        this.setupBasicConfiguration();
    }

    protected VWSystemConfiguration(VWSession theServiceSession, boolean bFetchSystemConfiguration) throws VWException {
        if (theServiceSession == null) {
            throw new VWException("vw.api.VWSystemConfigurationBadSession", "VWSession cannot be null for constructor");
        }
        this.serviceSession = theServiceSession;
        this.serviceSession.checkSession();
        if (bFetchSystemConfiguration) {
            this.fetchSystemConfig();
        } else {
            this.setupBasicConfiguration();
        }
    }

    private void fetchSystemConfig() throws VWException {
        int i;
        VWSystemConfigInfo systemConfig = null;
        this.m_bRetrievedFromServer = false;
        try {
            IPECommands cmdSess = this.serviceSession.getCmdSession();
            if (cmdSess != null) {
                systemConfig = cmdSess.getSystemConfigInfo(this.serviceSession.webAppId);
                this.m_bRetrievedFromServer = true;
            }
        }
        catch (VWNoOnlineClassesException ex) {
            // empty catch block
        }
        if (systemConfig == null) {
            systemConfig = new VWSystemConfigInfo();
        }
        this.QDefHandler = new VWArrayHandler();
        this.theQDefs = null;
        this.mandatoryQExpFields = null;
        this.mandatoryQIndexes = null;
        VWQueueDefinition[] theFetchedQDefs = systemConfig.getQueueDefinitions();
        if (theFetchedQDefs != null) {
            for (int i2 = 0; i2 < theFetchedQDefs.length; ++i2) {
                theFetchedQDefs[i2].setSession(this.serviceSession);
                theFetchedQDefs[i2].setSystemConfiguration(this);
                this.theQDefs = (VWQueueDefinition[])this.QDefHandler.addElementToArray(this.theQDefs, theFetchedQDefs[i2]);
                theFetchedQDefs[i2].initWorkBasketsFromOrb();
            }
        }
        this.LDefHandler = new VWArrayHandler();
        this.theLDefs = null;
        this.mandatoryLExpFields = null;
        this.mandatoryLIndexes = null;
        VWLogDefinition[] theFetchedLDefs = systemConfig.getLogDefinitions();
        if (theFetchedLDefs != null) {
            for (int i3 = 0; i3 < theFetchedLDefs.length; ++i3) {
                theFetchedLDefs[i3].setSession(this.serviceSession);
                this.theLDefs = (VWLogDefinition[])this.LDefHandler.addElementToArray(this.theLDefs, theFetchedLDefs[i3]);
            }
        }
        this.setDefaultLogDefinition(systemConfig.getDefaultLogDefinition());
        this.RDefHandler = new VWArrayHandler();
        this.theRDefs = null;
        this.mandatoryRExpFields = null;
        this.mandatoryRIndexes = null;
        VWRosterDefinition[] theFetchedRDefs = systemConfig.getRosterDefinitions();
        if (theFetchedRDefs != null) {
            for (int i4 = 0; i4 < theFetchedRDefs.length; ++i4) {
                theFetchedRDefs[i4].setSession(this.serviceSession);
                this.theRDefs = (VWRosterDefinition[])this.RDefHandler.addElementToArray(this.theRDefs, theFetchedRDefs[i4]);
            }
        }
        this.ApplicationSpaceDefHandler = new VWArrayHandler();
        this.theApplicationSpaceDefs = null;
        VWApplicationSpaceDefinition[] theFetchedApplicationSpaceDefs = systemConfig.getApplicationSpaceDefinitions();
        if (theFetchedApplicationSpaceDefs != null) {
            for (int i5 = 0; i5 < theFetchedApplicationSpaceDefs.length; ++i5) {
                theFetchedApplicationSpaceDefs[i5].initWorkBasketDefsForRoleDefs(this);
                theFetchedApplicationSpaceDefs[i5].setSession(this.serviceSession);
                this.theApplicationSpaceDefs = (VWApplicationSpaceDefinition[])this.ApplicationSpaceDefHandler.addElementToArray(this.theApplicationSpaceDefs, theFetchedApplicationSpaceDefs[i5]);
            }
        }
        this.SPDefHandler = new VWArrayHandler();
        this.theSPDefs = null;
        this.DeletedSPDefHandler = new VWArrayHandler();
        this.theDeletedSPDefs = null;
        VWStepProcessorInfoDefinition[] theFetchedSPDefs = systemConfig.getStepProcessorInfoDefinitions();
        if (theFetchedSPDefs != null) {
            int webAppId = this.serviceSession.getDefaultWebApplication();
            int regWebAppId = this.serviceSession.getIsolatedRegionWebApp();
            for (i = 0; i < theFetchedSPDefs.length; ++i) {
                theFetchedSPDefs[i].setDefaultWebAppId(webAppId);
                theFetchedSPDefs[i].setIsolatedRegionWebAppId(regWebAppId);
                this.theSPDefs = (VWStepProcessorInfoDefinition[])this.SPDefHandler.addElementToArray(this.theSPDefs, theFetchedSPDefs[i]);
            }
        }
        this.setLoggingState(systemConfig.getLoggingState(), true);
        this.setMaxDBOperations(systemConfig.getMaxDBOperations());
        this.setMaxInstructions(systemConfig.getMaxInstructions());
        this.setStatisticsCollection(systemConfig.getStatisticsCollection());
        this.setTrackAttachmentReferences(systemConfig.getTrackAttachmentReferences());
        this.mandatoryQExpFields = systemConfig.getMandatoryExposedFieldsForQueues();
        VWIndexDefinition[] mandatoryQIndexesFromServer = systemConfig.getMandatoryIndexesForQueues();
        VWArrayHandler indexHandlerQ = new VWArrayHandler();
        if (mandatoryQIndexesFromServer != null && mandatoryQIndexesFromServer.length == 0) {
            for (i = 0; i < mandatoryQIndexesFromServer.length; ++i) {
                this.mandatoryQIndexes = (VWIndexDefinition[])indexHandlerQ.addElementToArray(this.mandatoryQIndexes, mandatoryQIndexesFromServer[i]);
            }
        }
        String[] theWobNumFields = new String[]{"F_WobNum"};
        VWIndexDefinition F_WobNumIndex = new VWIndexDefinition("F_WobNum", theWobNumFields, true, null, true);
        F_WobNumIndex.setMandatorySystemIndex(true);
        this.mandatoryQIndexes = (VWIndexDefinition[])indexHandlerQ.addElementToArray(this.mandatoryQIndexes, F_WobNumIndex);
        String[] fifoFields = new String[]{"F_UniqueId"};
        VWIndexDefinition F_FifoIndex = new VWIndexDefinition("F_Fifo", fifoFields, true, null, true);
        F_FifoIndex.setMandatorySystemIndex(true);
        this.mandatoryQIndexes = (VWIndexDefinition[])indexHandlerQ.addElementToArray(this.mandatoryQIndexes, F_FifoIndex);
        String[] sortRuleFields = new String[]{"F_Locked", "F_SortOrder", "F_UniqueId"};
        VWIndexDefinition F_SortRule = new VWIndexDefinition("F_SortRule", sortRuleFields, true, null, true);
        F_SortRule.setMandatorySystemIndex(true);
        this.mandatoryQIndexes = (VWIndexDefinition[])indexHandlerQ.addElementToArray(this.mandatoryQIndexes, F_SortRule);
        this.mandatoryQIndexes = (VWIndexDefinition[])indexHandlerQ.getElements(this.mandatoryQIndexes);
        this.mandatoryRExpFields = systemConfig.getMandatoryExposedFieldsForRosters();
        VWIndexDefinition[] mandatoryRIndexesFromServer = systemConfig.getMandatoryIndexesForRosters();
        if (mandatoryRIndexesFromServer == null || mandatoryRIndexesFromServer.length == 0) {
            VWArrayHandler indexHandler = new VWArrayHandler();
            F_WobNumIndex.setMandatorySystemIndex(true);
            this.mandatoryRIndexes = (VWIndexDefinition[])indexHandler.addElementToArray(this.mandatoryRIndexes, F_WobNumIndex);
            String[] theWobTagFields = new String[]{"F_Tag", "F_WobNum"};
            VWIndexDefinition F_WobTagIndex = new VWIndexDefinition("F_WobTag", theWobTagFields, true, null, true);
            F_WobTagIndex.setMandatorySystemIndex(true);
            this.mandatoryRIndexes = (VWIndexDefinition[])indexHandler.addElementToArray(this.mandatoryRIndexes, F_WobTagIndex);
            this.mandatoryRIndexes = (VWIndexDefinition[])indexHandler.getElements(this.mandatoryRIndexes);
        }
        this.mandatoryLExpFields = systemConfig.getMandatoryExposedFieldsForLogs();
        this.mandatoryLIndexes = systemConfig.getMandatoryIndexesForLogs();
        this.attributes = systemConfig.getAttributes();
        this.bHasChanged = false;
    }

    private void setupBasicConfiguration() {
        try {
            this.createQueueDefinition("Inbox", 2);
        }
        catch (VWException vWException) {
            // empty catch block
        }
    }

    public String[] commit() throws VWException {
        if (this.serviceSession == null) {
            throw new VWException("vw.api.VWSystemConfigurationNullSession", "Commit cannot run - no valid VWSession.");
        }
        ChangedItems changedItems = this.getChangedItems();
        VWTransferResult theErrors = null;
        if (this.bHasChanged && changedItems != null) {
            this.serviceSession.checkSession();
            VWSystemConfigInfo theSystemConfig = new VWSystemConfigInfo();
            theSystemConfig.setQueueDefinitions(changedItems.getQueueDefinitions());
            theSystemConfig.setDefaultLogDefinition(changedItems.getTheChangedDefaultLogDef());
            theSystemConfig.setLogDefinitions(changedItems.getLogDefinitions());
            theSystemConfig.setRosterDefinitions(changedItems.getRosterDefinitions());
            theSystemConfig.setApplicationSpaceDefinitions(changedItems.getApplicationSpaceDefinitions());
            theSystemConfig.setStepProcessorInfoDefinitions(changedItems.getStepProcessorInfoDefinitions());
            theSystemConfig.setDeletedStepProcessorInfoDefinitions((VWStepProcessorInfoDefinition[])this.DeletedSPDefHandler.getElements(this.theDeletedSPDefs));
            theSystemConfig.setLoggingState(this.getLoggingState());
            theSystemConfig.setMaxDBOperations(this.getMaxDBOperations());
            theSystemConfig.setMaxInstructions(this.getMaxInstructions());
            theSystemConfig.setStatisticsCollection(this.getStatisticsCollection());
            theSystemConfig.setTrackAttachmentReferences(this.getTrackAttachmentReferences());
            theSystemConfig.setServerIDs(this.getServerIDs());
            theSystemConfig.setAttributes(this.attributes);
            theSystemConfig.setMandatoryFieldsIndexesForLogs(this.mandatoryLExpFields, this.mandatoryLIndexes);
            theSystemConfig.setMandatoryFieldsIndexesForQueues(this.mandatoryQExpFields, this.mandatoryQIndexes);
            theSystemConfig.setMandatoryFieldsIndexesForRosters(this.mandatoryRExpFields, this.mandatoryRIndexes);
            theErrors = this.serviceSession.getCmdSession().transfer(theSystemConfig, null, null, false, false, this.serviceSession.webAppId);
            if (theErrors.success()) {
                this.fetchSystemConfig();
            }
        }
        if (theErrors != null && theErrors.getErrors() != null) {
            return theErrors.getErrors();
        }
        return null;
    }

    private ChangedItems getChangedItems() throws VWException {
        int i;
        int nCount;
        VWLogDefinition theLDef;
        ChangedItems changedItems = new ChangedItems();
        if (this.QDefHandler != null) {
            for (int i2 = 0; i2 < this.QDefHandler.getElementCount(); ++i2) {
                if (!this.theQDefs[i2].hasChanged()) continue;
                VWIndexDefinition[] theIndexes = this.theQDefs[i2].getIndexes();
                if (theIndexes != null) {
                    for (int loop = 0; loop < theIndexes.length; ++loop) {
                        theIndexes[loop].setTableDefinition(this.theQDefs[i2]);
                    }
                }
                changedItems.addQueueDefinition(this.theQDefs[i2]);
                this.bHasChanged = true;
            }
        }
        if ((theLDef = this.getDefaultLogDefinition()) != null && theLDef.hasChanged()) {
            changedItems.setTheChangedDefaultLogDef(this.defaultLogDef);
            this.bHasChanged = true;
        }
        if (this.LDefHandler != null && (nCount = this.LDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                if (!this.theLDefs[i].hasChanged()) continue;
                changedItems.addLogDefinition(this.theLDefs[i]);
                this.bHasChanged = true;
            }
        }
        if (this.RDefHandler != null && (nCount = this.RDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                if (!this.theRDefs[i].hasChanged()) continue;
                changedItems.addRosterDefinition(this.theRDefs[i]);
                this.bHasChanged = true;
            }
        }
        if (this.ApplicationSpaceDefHandler != null && (nCount = this.ApplicationSpaceDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                if (!this.theApplicationSpaceDefs[i].hasChanged()) continue;
                changedItems.addApplicationSpaceDefinition(this.theApplicationSpaceDefs[i]);
                this.bHasChanged = true;
            }
        }
        if (this.SPDefHandler != null && (nCount = this.SPDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                if (!this.theSPDefs[i].hasChanged()) continue;
                changedItems.addStepProcessorInfoDefinition(this.theSPDefs[i]);
                this.bHasChanged = true;
            }
        }
        if (this.DeletedSPDefHandler != null && (nCount = this.DeletedSPDefHandler.getElementCount()) != 0) {
            this.bHasChanged = true;
        }
        return changedItems;
    }

    public boolean hasChanged() throws VWException {
        this.getChangedItems();
        return this.bHasChanged;
    }

    public VWQueueDefinition createQueueDefinition(String theName, int theQueueType) throws VWException {
        Object[] theElements = (VWQueueDefinition[])this.QDefHandler.getElements(this.theQDefs);
        int theIndex = this.QDefHandler.getIndexFromStringFieldValue(theElements, "name", theName);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWSystemConfigurationQueueExists", "The queue name already exists.");
        }
        VWQueueDefinition theQDef = this.constructDefaultQueueDef(theName, theQueueType);
        this.theQDefs = (VWQueueDefinition[])this.QDefHandler.addElementToArray(this.theQDefs, theQDef);
        this.bHasChanged = true;
        return theQDef;
    }

    public void deleteQueueDefinition(String theName) throws VWException {
        if (theName == null || theName.trim().length() == 0) {
            throw new VWException("vw.api.VWSystemConfigurationDeleteQueueNameNull", "Can not delete the queue definition with null or empty name.");
        }
        for (int i = 0; i < this.QDefHandler.getElementCount(); ++i) {
            if (!this.theQDefs[i].getName().equals(theName)) continue;
            if (this.theQDefs[i].getServerId() != -1) {
                throw new VWException("vw.api.VWSystemConfigurationDeleteQueueDef", "Transferred queue definitions cannot be deleted only modified.");
            }
            VWWorkBasketDefinition[] wbDefs = this.theQDefs[i].getWorkBasketDefinitions();
            if (wbDefs != null) {
                for (int j = 0; j < wbDefs.length; ++j) {
                    this.theQDefs[i].deleteWorkBasketDefinition(wbDefs[j].getAuthoredName());
                }
            }
            this.QDefHandler.deleteElementFromArray(this.theQDefs, i);
            return;
        }
        throw new VWException("vw.api.VWSystemConfigurationInvalidQueueDef", "Invalid queue definition object. Deletion failed.");
    }

    protected VWQueueDefinition constructDefaultQueueDef(String theName, int theQueueType) throws VWException {
        VWExposedFieldDefinition theNewField;
        if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWSystemConfigurationIllFormedQueueName", "Syntax error in Queue name.");
        }
        if (theQueueType != 1 && theQueueType != 2) {
            throw new VWException("vw.api.VWSystemConfigurationInvalidQueueType", "Invalid queue type, Queue type must be QUEUE_TYPE_PROCESS or QUEUE_TYPE_USER_CENTRIC.");
        }
        VWQueueDefinition theQDef = new VWQueueDefinition(theName, theQueueType);
        theQDef.setSystemConfiguration(this);
        if (this.mandatoryQExpFields != null) {
            theQDef.createFieldDefinitions(this.mandatoryQExpFields);
        } else {
            theNewField = theQDef.createFieldDefinition("F_EnqueueTime", 16, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
            theNewField = theQDef.createFieldDefinition("F_CreateTime", 16, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
            theNewField = theQDef.createFieldDefinition("F_LockTime", 16, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
            theNewField = theQDef.createFieldDefinition("F_LockUser", 1, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
            if (theQueueType == 2) {
                theNewField = theQDef.createFieldDefinition("F_BoundUser", 1, 0);
                theNewField.setMandatorySystemField(true);
                theNewField.setHasChanged(true);
            }
        }
        theNewField = theQDef.createFieldDefinition("F_Overdue", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theQDef.createFieldDefinition("F_Subject", 2, 80);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theQDef.createFieldDefinition("F_TimeOut", 16, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        if (this.mandatoryQIndexes != null) {
            for (int i = 0; i < this.mandatoryQIndexes.length; ++i) {
                this.mandatoryQIndexes[i].setTableDefinition(theQDef);
            }
            theQDef.createIndexDefinitions(this.mandatoryQIndexes);
        }
        theQDef.setHasChanged(true);
        return theQDef;
    }

    public void updateQueueDefinition(VWQueueDefinition theQueueDefinition) throws VWException {
        int theIndex = this.QDefHandler.getIndexFromStringFieldValue(this.theQDefs, "name", theQueueDefinition.getName());
        if (theIndex == -1) {
            throw new VWException("vw.api.VWSystemConfigurationQueueDoesNotExist", "The queue definition does not exist.");
        }
        this.QDefHandler.replaceElementInArray(this.theQDefs, theQueueDefinition, theIndex);
        this.bHasChanged = true;
    }

    public VWQueueDefinition[] getQueueDefinitions() throws VWException {
        return (VWQueueDefinition[])this.QDefHandler.getElements(this.theQDefs);
    }

    public VWQueueDefinition getQueueDefinition(String name) throws VWException {
        VWQueueDefinition[] qdefs = this.getQueueDefinitions();
        if (qdefs != null) {
            for (int i = 0; i < qdefs.length; ++i) {
                if (!qdefs[i].getName().equals(name)) continue;
                return qdefs[i];
            }
        }
        return null;
    }

    public VWLogDefinition getDefaultLogDefinition() throws VWException {
        if (this.defaultLogDef == null) {
            return null;
        }
        String theName = this.defaultLogDef.getName();
        int theIndex = this.LDefHandler.getIndexFromStringFieldValue(this.theLDefs, "name", theName);
        if (theIndex == -1) {
            throw new VWException("vw.api.VWSystemConfigurationDefaultLogNotFound", "Unable to find the default log.");
        }
        return this.theLDefs[theIndex];
    }

    private void setDefaultLogDefinition(VWLogDefinition theLogDefinition) {
        this.defaultLogDef = theLogDefinition;
    }

    public VWLogDefinition createLogDefinition(String theName) throws VWException {
        Object[] theElements = (VWLogDefinition[])this.LDefHandler.getElements(this.theLDefs);
        int theIndex = this.LDefHandler.getIndexFromStringFieldValue(theElements, "name", theName);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWSystemConfigurationLogExists", "The log name \"{0}\" already exists.", theName);
        }
        VWLogDefinition theLDef = this.constructDefaultLogDef(theName);
        this.theLDefs = (VWLogDefinition[])this.LDefHandler.addElementToArray(this.theLDefs, theLDef);
        this.bHasChanged = true;
        return theLDef;
    }

    public void deleteLogDefinition(String theName) throws VWException {
        if (theName == null || theName.trim().length() == 0) {
            throw new VWException("vw.api.VWSystemConfigurationDeleteLogNameNull", "Can not delete the event log definition with null or empty name.");
        }
        for (int i = 0; i < this.LDefHandler.getElementCount(); ++i) {
            if (!this.theLDefs[i].getName().equals(theName)) continue;
            if (this.theLDefs[i].getServerId() != -1) {
                throw new VWException("vw.api.VWSystemConfigurationDeleteLogDef", "Transferred event log definitions cannot be deleted only modified.");
            }
            this.LDefHandler.deleteElementFromArray(this.theLDefs, i);
            return;
        }
        throw new VWException("vw.api.VWSystemConfigurationInvalidLogDef", "Invalid event log definition object. Deletion failed.");
    }

    protected VWLogDefinition constructDefaultLogDef(String theName) throws VWException {
        VWExposedFieldDefinition theNewField;
        if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWSystemConfigurationIllFormedLogName", "Syntax error in Log name.");
        }
        VWLogDefinition theLDef = new VWLogDefinition(theName);
        if (this.mandatoryLExpFields != null) {
            theLDef.createFieldDefinitions(this.mandatoryLExpFields);
        } else {
            theNewField = theLDef.createFieldDefinition("F_TimeStamp", 16, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
            theNewField = theLDef.createFieldDefinition("F_SeqNumber", 1, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
        }
        theNewField = theLDef.createFieldDefinition("F_Originator", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_Subject", 2, 80);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_Comment", 2, 80);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_Response", 2, 31);
        theNewField.setHasChanged(true);
        theNewField.setSystemField(true);
        theNewField = theLDef.createFieldDefinition("F_WorkFlowNumber", 2, 16);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_StepStatus", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_TrackerStatus", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_UniqueId", 8, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_StartTime", 16, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_EnqueueTime", 16, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theLDef.createFieldDefinition("F_WFDeadline", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        if (this.mandatoryLIndexes != null) {
            theLDef.createIndexDefinitions(this.mandatoryLIndexes);
        }
        String[] theFieldNames = new String[]{"F_WorkFlowNumber"};
        VWIndexDefinition theNewIndex = theLDef.createIndexDefinition("F_WorkFlowNumber", theFieldNames, true);
        theNewIndex.setSystemIndex(true);
        theNewIndex.setTableDefinition(theLDef);
        theNewIndex.setHasChanged(true);
        theLDef.setHasChanged(true);
        return theLDef;
    }

    public void updateLogDefinition(VWLogDefinition theLogDefinition) throws VWException {
        int theIndex = this.LDefHandler.getIndexFromStringFieldValue(this.theLDefs, "name", theLogDefinition.getName());
        if (theIndex == -1) {
            throw new VWException("vw.api.VWSystemConfigurationLogDoesNotExist", "The log definition does not exist.");
        }
        this.LDefHandler.replaceElementInArray(this.theLDefs, theLogDefinition, theIndex);
        this.bHasChanged = true;
    }

    public VWLogDefinition[] getLogDefinitions() throws VWException {
        return (VWLogDefinition[])this.LDefHandler.getElements(this.theLDefs);
    }

    public VWLogDefinition getLogDefinition(String name) throws VWException {
        VWLogDefinition[] ldefs = this.getLogDefinitions();
        if (ldefs != null) {
            for (int i = 0; i < ldefs.length; ++i) {
                if (!ldefs[i].getName().equals(name)) continue;
                return ldefs[i];
            }
        }
        return null;
    }

    public VWRosterDefinition createRosterDefinition(String theName) throws VWException {
        Object[] theElements = (VWRosterDefinition[])this.RDefHandler.getElements(this.theRDefs);
        int theIndex = this.RDefHandler.getIndexFromStringFieldValue(theElements, "name", theName);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWSystemConfigurationRosterExists", "The roster name already exists.");
        }
        VWRosterDefinition theRDef = this.constructDefaultRosterDef(theName);
        this.theRDefs = (VWRosterDefinition[])this.RDefHandler.addElementToArray(this.theRDefs, theRDef);
        this.bHasChanged = true;
        return theRDef;
    }

    public void deleteRosterDefinition(String theName) throws VWException {
        if (theName == null || theName.trim().length() == 0) {
            throw new VWException("vw.api.VWSystemConfigurationDeleteRosterNameNull", "Can not delete the roster definition with null or empty name.");
        }
        for (int i = 0; i < this.RDefHandler.getElementCount(); ++i) {
            if (!this.theRDefs[i].getName().equals(theName)) continue;
            if (this.theRDefs[i].getServerId() != -1) {
                throw new VWException("vw.api.VWSystemConfigurationDeleteRosterDef", "Transferred roster definitions cannot be deleted only modified.");
            }
            this.RDefHandler.deleteElementFromArray(this.theRDefs, i);
            return;
        }
        throw new VWException("vw.api.VWSystemConfigurationInvalidRosterDef", "Invalid roster definition object. Deletion failed.");
    }

    protected VWRosterDefinition constructDefaultRosterDef(String theName) throws VWException {
        VWExposedFieldDefinition theNewField;
        if (!VWFieldType.isValidName(theName)) {
            throw new VWException("vw.api.VWSystemConfigurationIllFormedRosterName", "Syntax error in Roster name.");
        }
        VWRosterDefinition theRDef = new VWRosterDefinition(theName);
        if (this.mandatoryRExpFields != null) {
            theRDef.createFieldDefinitions(this.mandatoryRExpFields);
        } else {
            theNewField = theRDef.createFieldDefinition("F_WobNum", 2, 0);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
            theNewField = theRDef.createFieldDefinition("F_Tag", 2, 64);
            theNewField.setMandatorySystemField(true);
            theNewField.setHasChanged(true);
        }
        theNewField = theRDef.createFieldDefinition("F_Originator", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theRDef.createFieldDefinition("F_Subject", 2, 80);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theRDef.createFieldDefinition("F_StartTime", 16, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theRDef.createFieldDefinition("F_TrackerStatus", 1, 0);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        theNewField = theRDef.createFieldDefinition("F_WorkFlowNumber", 2, 16);
        theNewField.setSystemField(true);
        theNewField.setHasChanged(true);
        if (this.mandatoryRIndexes != null) {
            for (int i = 0; i < this.mandatoryRIndexes.length; ++i) {
                this.mandatoryRIndexes[i].setTableDefinition(theRDef);
            }
            theRDef.createIndexDefinitions(this.mandatoryRIndexes);
        }
        String[] theFieldNames = new String[]{"F_WorkFlowNumber"};
        VWIndexDefinition theNewIndex = theRDef.createIndexDefinition("F_WorkFlowNumber", theFieldNames, true);
        theNewIndex.setSystemIndex(true);
        theNewIndex.setHasChanged(false);
        theRDef.setHasChanged(true);
        return theRDef;
    }

    public void updateRosterDefinition(VWRosterDefinition theRosterDefinition) throws VWException {
        int theIndex = this.RDefHandler.getIndexFromStringFieldValue(this.theRDefs, "name", theRosterDefinition.getName());
        if (theIndex == -1) {
            throw new VWException("vw.api.VWSystemConfigurationRosterDoesNotExist", "The roster definition does not exist.");
        }
        this.RDefHandler.replaceElementInArray(this.theRDefs, theRosterDefinition, theIndex);
        this.bHasChanged = true;
    }

    public VWRosterDefinition[] getRosterDefinitions() throws VWException {
        return (VWRosterDefinition[])this.RDefHandler.getElements(this.theRDefs);
    }

    public VWRosterDefinition getRosterDefinition(String name) throws VWException {
        VWRosterDefinition[] rdefs = this.getRosterDefinitions();
        if (rdefs != null) {
            for (int i = 0; i < rdefs.length; ++i) {
                if (!rdefs[i].getName().equals(name)) continue;
                return rdefs[i];
            }
        }
        return null;
    }

    public VWStepProcessorInfoDefinition createStepProcessorInfoDefinition() throws VWException {
        VWStepProcessorInfoDefinition aSPDef = new VWStepProcessorInfoDefinition();
        aSPDef.setHasChanged(true);
        if (this.serviceSession != null) {
            aSPDef.setDefaultWebAppId(this.serviceSession.getDefaultWebApplication());
            aSPDef.setIsolatedRegionWebAppId(this.serviceSession.getIsolatedRegionWebApp());
        }
        this.theSPDefs = (VWStepProcessorInfoDefinition[])this.SPDefHandler.addElementToArray(this.theSPDefs, aSPDef);
        this.bHasChanged = true;
        return aSPDef;
    }

    public void deleteStepProcessorInfoDefinition(VWStepProcessorInfoDefinition theSPDef) throws VWException {
        for (int i = 0; i < this.SPDefHandler.getElementCount(); ++i) {
            if (!this.theSPDefs[i].equals(theSPDef)) continue;
            if (this.theSPDefs[i].getId() != -1) {
                throw new VWException("vw.api.VWSystemConfigurationDeleteStepProcessorDef", "Transferred step processor definitions cannot be deleted only modified.");
            }
            this.SPDefHandler.deleteElementFromArray(this.theSPDefs, i);
            this.bHasChanged = true;
            return;
        }
        throw new VWException("vw.api.VWSystemConfigurationInvalidStepProcessorDef", "Invalid step processor definition object. Deletion failed.");
    }

    public VWStepProcessorInfoDefinition[] getStepProcessorInfoDefinitions() throws VWException {
        return (VWStepProcessorInfoDefinition[])this.SPDefHandler.getElements(this.theSPDefs);
    }

    public VWStepProcessorInfoDefinition getStepProcessorInfoDefinition(String name) throws VWException {
        VWStepProcessorInfoDefinition[] spdefs = this.getStepProcessorInfoDefinitions();
        if (spdefs != null) {
            for (int i = 0; i < spdefs.length; ++i) {
                if (!spdefs[i].getName().equals(name)) continue;
                return spdefs[i];
            }
        }
        return null;
    }

    public VWApplicationSpaceDefinition createApplicationSpaceDefinition(String name) throws VWException {
        if (name == null || name.trim().length() == 0) {
            throw new VWException("vw.api.VWSystemConfigurationCreateAppSpaceNameNull", "Can not create an application space definition with a null or empty name.");
        }
        Object[] theElements = (VWApplicationSpaceDefinition[])this.ApplicationSpaceDefHandler.getElements(this.theApplicationSpaceDefs);
        int theIndex = this.ApplicationSpaceDefHandler.getIndexFromStringFieldValue(theElements, "m_name", name);
        if (theIndex != -1) {
            throw new VWException("vw.api.VWSystemConfigurationApplicationSpaceDefExists", "The application space definition name already exists.");
        }
        VWApplicationSpaceDefinition aApplicationSpaceDef = new VWApplicationSpaceDefinition(0, name, null);
        aApplicationSpaceDef.setSession(this.serviceSession);
        aApplicationSpaceDef.setHasChanged(true);
        this.theApplicationSpaceDefs = (VWApplicationSpaceDefinition[])this.ApplicationSpaceDefHandler.addElementToArray(this.theApplicationSpaceDefs, aApplicationSpaceDef);
        this.bHasChanged = true;
        return aApplicationSpaceDef;
    }

    public void deleteApplicationSpaceDefinition(String theName) throws VWException {
        if (theName == null || theName.trim().length() == 0) {
            throw new VWException("vw.api.VWSystemConfigurationDeleteAppSpaceNameNull", "Can not delete the application space definition with null or empty name.");
        }
        for (int i = 0; i < this.ApplicationSpaceDefHandler.getElementCount(); ++i) {
            if (!this.theApplicationSpaceDefs[i].getName().equals(theName)) continue;
            if (this.theApplicationSpaceDefs[i].getObjId() != -1) {
                throw new VWException("vw.api.VWSystemConfigurationDeleteApplicationSpaceDef", "Transferred application space definitions cannot be deleted only modified.");
            }
            this.ApplicationSpaceDefHandler.deleteElementFromArray(this.theApplicationSpaceDefs, i);
            return;
        }
        throw new VWException("vw.api.VWSystemConfigurationInvalidApplicationSpaceDef", "Invalid application space definition object. Deletion failed.");
    }

    public void updateApplicationSpaceDefinition(VWApplicationSpaceDefinition theApplicationSpaceDef) throws VWException {
        if (theApplicationSpaceDef == null) {
            throw new VWException("vw.api.VWSystemConfigurationApplicationSpaceDefNull", "Can not update a null application space definition.");
        }
        int theIndex = this.ApplicationSpaceDefHandler.getIndexFromStringFieldValue(this.theApplicationSpaceDefs, "m_name", theApplicationSpaceDef.getName());
        if (theIndex == -1) {
            throw new VWException("vw.api.VWSystemConfigurationApplicationSpaceDefDoesNotExist", "The application space definition does not exist.");
        }
        this.ApplicationSpaceDefHandler.replaceElementInArray(this.theApplicationSpaceDefs, theApplicationSpaceDef, theIndex);
        this.bHasChanged = true;
    }

    public VWApplicationSpaceDefinition[] getApplicationSpaceDefinitions() throws VWException {
        return (VWApplicationSpaceDefinition[])this.ApplicationSpaceDefHandler.getElements(this.theApplicationSpaceDefs);
    }

    public VWApplicationSpaceDefinition getApplicationSpaceDefinition(String name) throws VWException {
        if (name == null || name.trim().length() == 0) {
            throw new VWException("vw.api.VWSystemConfigurationGetAppSpaceNameNull", "Can not get the application space definition with null or empty name.");
        }
        VWApplicationSpaceDefinition[] appSpaceDefs = this.getApplicationSpaceDefinitions();
        if (appSpaceDefs != null) {
            for (int i = 0; i < appSpaceDefs.length; ++i) {
                if (!appSpaceDefs[i].getName().equals(name)) continue;
                return appSpaceDefs[i];
            }
        }
        return null;
    }

    public boolean getLoggingState(int theLoggingOption) {
        return (this.theLoggingOptions & theLoggingOption) > 0;
    }

    public int getLoggingState() {
        return this.theLoggingOptions & 0xC05117F0;
    }

    public int setLoggingState(int newLoggingOptions, boolean turnOn) throws VWException {
        this.theLoggingOptions = (newLoggingOptions &= 0xC05117F0) == 0 ? (turnOn ? 0 : -1068427280) : (turnOn ? (this.theLoggingOptions |= newLoggingOptions) : (this.theLoggingOptions &= ~newLoggingOptions));
        this.bHasChanged = true;
        return this.theLoggingOptions;
    }

    public int getMaxDBOperations() {
        return this.maxDBOperations;
    }

    public void setMaxDBOperations(int theMaxOperations) {
        this.bHasChanged = true;
        this.maxDBOperations = theMaxOperations;
    }

    public int getMaxInstructions() {
        return this.maxInstructions;
    }

    public void setMaxInstructions(int theMaxInstructions) {
        this.bHasChanged = true;
        this.maxInstructions = theMaxInstructions;
    }

    public Integer[] getServerIDs() {
        Integer[] serverIDs = new Integer[]{0};
        return serverIDs;
    }

    public boolean getStatisticsCollection() {
        return this.bStatisticsCollectionOn;
    }

    public void setStatisticsCollection(boolean turnOn) {
        this.bHasChanged = true;
        this.bStatisticsCollectionOn = turnOn;
    }

    public boolean getTrackAttachmentReferences() {
        return this.bTrackAttachmentReferences;
    }

    public void setTrackAttachmentReferences(boolean turnOn) {
        this.bHasChanged = true;
        this.bTrackAttachmentReferences = turnOn;
    }

    public static String getLocalizedString(int theLogType) throws VWException {
        int offSet = 0;
        switch (theLogType) {
            case 0: {
                offSet = 0;
                break;
            }
            case -1068427280: {
                offSet = 1;
                break;
            }
            case 256: {
                offSet = 2;
                break;
            }
            case 512: {
                offSet = 3;
                break;
            }
            case 1024: {
                offSet = 4;
                break;
            }
            case 4096: {
                offSet = 5;
                break;
            }
            case 128: {
                offSet = 6;
                break;
            }
            case 0x100000: {
                offSet = 7;
                break;
            }
            case 0x400000: {
                offSet = 8;
                break;
            }
            case 0x40000000: {
                offSet = 9;
                break;
            }
            case -2147483648: {
                offSet = 10;
                break;
            }
            case 65536: {
                offSet = 11;
                break;
            }
            case 64: {
                offSet = 12;
                break;
            }
            case 16: {
                offSet = 13;
                break;
            }
            case 32: {
                offSet = 14;
                break;
            }
            default: {
                throw new VWException("vw.api.VWSystemConfigurationBadLogType", "The log type is invalid: {0}", String.valueOf(theLogType));
            }
        }
        return LocalizedStrings[offSet];
    }

    public VWExposedFieldDefinition[] getExposedFields() throws VWException {
        int j;
        int i;
        VWQueueDefinition[] queueDefs = this.getQueueDefinitions();
        VWRosterDefinition[] rosterDefs = this.getRosterDefinitions();
        VWLogDefinition[] logDefs = this.getLogDefinitions();
        VWExposedFieldDefinition[] qExposedFields = null;
        VWExposedFieldDefinition[] rExposedFields = null;
        VWExposedFieldDefinition[] lExposedFields = null;
        Vector<VWExposedFieldDefinition> vExposedFields = new Vector<VWExposedFieldDefinition>();
        for (i = 0; i < queueDefs.length; ++i) {
            qExposedFields = queueDefs[i].getFields();
            for (j = 0; j < qExposedFields.length; ++j) {
                vExposedFields.addElement(qExposedFields[j]);
            }
        }
        for (i = 0; i < rosterDefs.length; ++i) {
            rExposedFields = rosterDefs[i].getFields();
            for (j = 0; j < rExposedFields.length; ++j) {
                vExposedFields.addElement(rExposedFields[j]);
            }
        }
        for (i = 0; i < logDefs.length; ++i) {
            lExposedFields = logDefs[i].getFields();
            for (j = 0; j < lExposedFields.length; ++j) {
                vExposedFields.addElement(lExposedFields[j]);
            }
        }
        Object[] exposedFields = new VWExposedFieldDefinition[vExposedFields.size()];
        vExposedFields.copyInto(exposedFields);
        return exposedFields;
    }

    public VWAttributeInfo getAttributeInfo() throws VWException {
        return new VWAttributeInfo(this.attributes);
    }

    public void setAttributeInfo(VWAttributeInfo theAttributeInfo) throws VWException {
        this.bHasChanged = true;
        if (theAttributeInfo != null) {
            VWGuid osID = this.getObjectStoreId();
            this.attributes = theAttributeInfo.attributes;
            if (osID != null) {
                this.setObjectStoreId(osID);
            }
        } else {
            this.attributes = null;
        }
    }

    protected Hashtable getAttributes() throws VWException {
        return this.attributes;
    }

    protected void setAttributes(Hashtable theAttributes) throws VWException {
        this.attributes = theAttributes;
    }

    protected String[] getAttributeNames() throws VWException {
        return VWAttributeInfo.getAttributeNames(this.attributes);
    }

    public String toString() {
        if (this.serviceSession != null) {
            return String.valueOf(this.serviceSession.isolatedRegion);
        }
        return String.valueOf(-1);
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        this.toXML(theBuffer, null);
    }

    protected void toXML(StringBuffer theBuffer, String baseIndent) throws VWException {
        int i;
        int nCount;
        if (theBuffer == null) {
            throw new VWException("vw.api.VWSystemConfigurationNullBuffer", "buffer parameter cannot be null.");
        }
        if (baseIndent == null) {
            baseIndent = "";
        }
        String INDENT_0 = baseIndent;
        String INDENT_1 = INDENT_0 + "\t";
        String INDENT_2 = INDENT_1 + "\t";
        if (this.isSelectedForExport) {
            theBuffer.append(INDENT_0 + "<" + "SystemConfiguration" + "\n");
            if (this.maxDBOperations > 0) {
                theBuffer.append(INDENT_1 + "MaxDBOperations" + "=\"" + this.maxDBOperations + "\"\n");
            }
            if (this.maxInstructions > 0) {
                theBuffer.append(INDENT_1 + "MaxInstructions" + "=\"" + this.maxInstructions + "\"\n");
            }
            if (this.theLoggingOptions != 0) {
                theBuffer.append(INDENT_1 + "LoggingState" + "=\"" + this.getLoggingState() + "\"\n");
            }
            theBuffer.append(INDENT_1 + "StatisticsCollection" + "=\"" + this.bStatisticsCollectionOn + "\"\n");
            theBuffer.append(INDENT_1 + "TrackingAttachment" + "=\"" + this.bTrackAttachmentReferences + "\">\n");
        } else {
            theBuffer.append(INDENT_0 + "<" + "SystemConfiguration" + ">\n");
        }
        theBuffer.append(INDENT_1 + "<" + "ArrayOfLogDefinition" + ">\n");
        if (this.LDefHandler != null && (nCount = this.LDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theLDefs[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfLogDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfQueueDefinition" + ">\n");
        if (this.QDefHandler != null && (nCount = this.QDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theQDefs[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfQueueDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfRosterDefinition" + ">\n");
        if (this.RDefHandler != null && (nCount = this.RDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theRDefs[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfRosterDefinition" + ">\n");
        theBuffer.append(INDENT_1 + "<" + "ArrayOfApplicationSpaceDefinition" + ">\n");
        if (this.ApplicationSpaceDefHandler != null && (nCount = this.ApplicationSpaceDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theApplicationSpaceDefs[i].toXML(theBuffer, INDENT_2);
            }
        }
        theBuffer.append(INDENT_1 + "</" + "ArrayOfApplicationSpaceDefinition" + ">\n");
        if (this.isSelectedForExport) {
            theBuffer.append(INDENT_1 + "<" + "ArrayOfStepProcessorInfoDefinition" + ">\n");
            if (this.SPDefHandler != null && (nCount = this.SPDefHandler.getElementCount()) != 0) {
                for (i = 0; i < nCount; ++i) {
                    this.theSPDefs[i].toXML(theBuffer, INDENT_2);
                }
            }
            theBuffer.append(INDENT_1 + "</" + "ArrayOfStepProcessorInfoDefinition" + ">\n");
            VWAttributeInfo theAttributeInfo = this.getAttributeInfo();
            theAttributeInfo.toXML(theBuffer, INDENT_1);
        }
        theBuffer.append(INDENT_0 + "</" + "SystemConfiguration" + ">\n");
    }

    protected void setIsSelectedForExport(boolean selectIt) {
        int nCount;
        this.isSelectedForExport = selectIt;
        if (this.SPDefHandler != null && (nCount = this.SPDefHandler.getElementCount()) != 0) {
            for (int i = 0; i < nCount; ++i) {
                this.theSPDefs[i].setIsSelectedForExport(selectIt);
            }
        }
    }

    protected boolean getIsSelectedForExport() {
        return this.isSelectedForExport;
    }

    public StringBuffer importConfig(InputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWSystemConfigurationNullInputStream", "The isolated region configuration could not be read. The input stream value is null. \nSpecify a valid input stream.");
        }
        try {
            InputStreamReader isr = new InputStreamReader(theStream, "UTF8");
            BufferedReader in = new BufferedReader(isr);
            return this.importConfig(in);
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.api.VWSystemConfigurationXMLReadError_1", "The isolated region configuration could not be read. The following XML could not be processed: {0}. \nEnsure that valid XML is specified.", ex.getLocalizedMessage());
            theException.setCause(ex);
            throw theException;
        }
    }

    public StringBuffer importConfig(String theFileName) throws VWException {
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(theFileName);
            StringBuffer stringBuffer = this.importConfig(istream);
            return stringBuffer;
        }
        catch (Exception ex) {
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            VWException theException = new VWException("vw.api.VWSystemConfigurationXMLReadFromFileError", " Exception reading XML file: {0}.", ex.getLocalizedMessage());
            theException.setCause(ex);
            throw theException;
        }
        finally {
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    protected StringBuffer importConfig(BufferedReader in) throws VWException {
        StringBuffer parsingLog = null;
        try {
            parsingLog = VWXMLConfiguration.parseConfigurationXML(this, this.serviceSession, in);
        }
        catch (SAXParseException err) {
            VWString parsingError = new VWString("vw.api.ParsingError", "** Parsing error");
            VWString line = new VWString("vw.api.Line", "line");
            String errString = parsingError + ", " + line + " " + err.getLineNumber() + ", uri " + err.getSystemId() + "\n" + "   " + err.getLocalizedMessage();
            VWException theException = new VWException("vw.api.VWSystemConfigurationXMLReadParse", "XML Parsing error {0}.", errString);
            theException.setCause(err);
            throw theException;
        }
        catch (Exception ex) {
            VWException theException = new VWException("vw.api.VWSystemConfigurationXMLReadError_2", "XML Reading error {0}", ex.getLocalizedMessage());
            theException.setCause(ex);
            throw theException;
        }
        return parsingLog;
    }

    public void exportConfigChanges(OutputStream theStream) throws VWException {
        if (theStream == null) {
            throw new VWException("vw.api.VWSystemConfigurationNullStream", "output stream parameter is null");
        }
        try {
            this.setSelectionForExport();
            StringBuffer configXML = new StringBuffer();
            IVWtoXML[] items = new IVWtoXML[]{this};
            VWXMLConfiguration.exportConfiguration(items, configXML);
            OutputStreamWriter out = new OutputStreamWriter(theStream, "UTF8");
            out.write(configXML.toString());
            ((Writer)out).flush();
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWSystemConfigurationXMLWriteError", " Exception writing XML: {0}.", ex.getLocalizedMessage());
        }
    }

    public void exportConfigChanges(String theFileName) throws VWException {
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(theFileName);
            this.exportConfigChanges(ostream);
        }
        catch (Exception ex) {
            throw new VWException("vw.api.VWSystemConfigurationXMLWriteToFileError", " Exception writing XML to file: {0}.", ex.getLocalizedMessage());
        }
        finally {
            if (ostream != null) {
                try {
                    ((OutputStream)ostream).close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private void setSelectionForExport() throws VWException {
        int i;
        int nCount;
        this.setIsSelectedForExport(true);
        if (this.LDefHandler != null && (nCount = this.LDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theLDefs[i].setIsSelectedForExport(this.theLDefs[i].hasChanged());
            }
        }
        if (this.QDefHandler != null && (nCount = this.QDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theQDefs[i].setIsSelectedForExport(this.theQDefs[i].hasChanged());
            }
        }
        if (this.RDefHandler != null && (nCount = this.RDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theRDefs[i].setIsSelectedForExport(this.theRDefs[i].hasChanged());
            }
        }
        if (this.ApplicationSpaceDefHandler != null && (nCount = this.ApplicationSpaceDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theApplicationSpaceDefs[i].setIsSelectedForExport(this.theApplicationSpaceDefs[i].hasChanged());
            }
        }
        if (this.SPDefHandler != null && (nCount = this.SPDefHandler.getElementCount()) != 0) {
            for (i = 0; i < nCount; ++i) {
                this.theSPDefs[i].setIsSelectedForExport(this.theSPDefs[i].hasChanged());
            }
        }
    }

    public VWGuid getObjectStoreId() throws VWException {
        if (this.attributes != null && this.attributes.containsKey(ATTRINFO_CONFIG_OBJECT_STORE_ID)) {
            return (VWGuid)this.attributes.get(ATTRINFO_CONFIG_OBJECT_STORE_ID);
        }
        return null;
    }

    public void setObjectStoreId(VWGuid newObjectStoreId) throws VWException {
        if (newObjectStoreId != null && newObjectStoreId.isUndefined()) {
            throw new VWException("vw.api.VWSystemConfigurationInvalidObjectStoreId", "The object store ID can not be set to the undefined (default) guid value.");
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        if (newObjectStoreId == null) {
            this.attributes.remove(ATTRINFO_CONFIG_OBJECT_STORE_ID);
        } else {
            this.attributes.put(ATTRINFO_CONFIG_OBJECT_STORE_ID, newObjectStoreId);
        }
        this.bHasChanged = true;
    }

    public String getObjectStoreSymbolicName() throws VWException {
        VWGuid objectStoreId;
        if (this.objectStoreSymbolicName == null && (objectStoreId = this.getObjectStoreId()) != null && this.serviceSession != null && this.serviceSession.getCmdSession() != null) {
            this.objectStoreSymbolicName = this.serviceSession.getCmdSession().fetchObjectStoreSymbolicName(objectStoreId);
        }
        return this.objectStoreSymbolicName;
    }

    public void setObjectStoreSymbolicName(String newObjectStoreSymbolicName) throws VWException {
        if (newObjectStoreSymbolicName == null || newObjectStoreSymbolicName.length() == 0) {
            this.setObjectStoreId(null);
            this.objectStoreSymbolicName = null;
            return;
        }
        if (this.serviceSession == null || this.serviceSession.getCmdSession() == null) {
            throw new VWException("vw.api.VWSystemConfigurationCannotLookupObjectStoreId", "The object store ID could not be set. The object store ID was not retrieved. Ensure there is an active session.");
        }
        VWGuid objectStoreId = this.serviceSession.getCmdSession().fetchObjectStoreId(newObjectStoreSymbolicName);
        this.setObjectStoreId(objectStoreId);
        this.objectStoreSymbolicName = newObjectStoreSymbolicName;
    }

    public boolean getIsRetrievedFromServer() {
        return this.m_bRetrievedFromServer;
    }

    private static class ChangedItems {
        private VWLogDefinition theChangedDefaultLogDef = null;
        private ArrayList<VWQueueDefinition> theChangedQDefs = new ArrayList();
        private ArrayList<VWRosterDefinition> theChangedRDefs = new ArrayList();
        private ArrayList<VWLogDefinition> theChangedLDefs = new ArrayList();
        private ArrayList<VWApplicationSpaceDefinition> theChangedASDefs = new ArrayList();
        private ArrayList<VWStepProcessorInfoDefinition> theChangedSPDefs = new ArrayList();

        ChangedItems() {
        }

        VWLogDefinition getTheChangedDefaultLogDef() {
            return this.theChangedDefaultLogDef;
        }

        void setTheChangedDefaultLogDef(VWLogDefinition defaultLogDef) {
            this.theChangedDefaultLogDef = defaultLogDef;
        }

        VWQueueDefinition[] getQueueDefinitions() {
            return this.theChangedQDefs.toArray(new VWQueueDefinition[0]);
        }

        void addQueueDefinition(VWQueueDefinition changedQueueDef) {
            this.theChangedQDefs.add(changedQueueDef);
        }

        VWRosterDefinition[] getRosterDefinitions() {
            return this.theChangedRDefs.toArray(new VWRosterDefinition[0]);
        }

        void addRosterDefinition(VWRosterDefinition changedRosterDef) {
            this.theChangedRDefs.add(changedRosterDef);
        }

        VWLogDefinition[] getLogDefinitions() {
            return this.theChangedLDefs.toArray(new VWLogDefinition[0]);
        }

        void addLogDefinition(VWLogDefinition theChangedLogDef) {
            this.theChangedLDefs.add(theChangedLogDef);
        }

        VWApplicationSpaceDefinition[] getApplicationSpaceDefinitions() {
            return this.theChangedASDefs.toArray(new VWApplicationSpaceDefinition[0]);
        }

        void addApplicationSpaceDefinition(VWApplicationSpaceDefinition theChangedASDef) {
            this.theChangedASDefs.add(theChangedASDef);
        }

        VWStepProcessorInfoDefinition[] getStepProcessorInfoDefinitions() {
            return this.theChangedSPDefs.toArray(new VWStepProcessorInfoDefinition[0]);
        }

        void addStepProcessorInfoDefinition(VWStepProcessorInfoDefinition theChangedSPDef) {
            this.theChangedSPDefs.add(theChangedSPDef);
        }
    }
}

